// IGCshell.cpp : Defines the class behaviors for the application.
//
// Copyright (c) 2000-2001 Marc Ramsey. All rights reserved.
//
// http://www.ranlog.com/ramsey/
//
// This software is provided as is with no warranties of any kind, 
// including the warranties of design, merchantibility and fitness 
// for a particular purpose, noninfringement, or arising from a 
// course of dealing, usage or trade practice.  This software is 
// provided with no support and without any obligation to assist in 
// its use, correction, modification, or enhancement.
//
// Permission to use, copy, or modify this software for any purpose 
// is hereby granted without fee, provided the above notices are 
// retained on all copies of the source code. 

#include "stdafx.h"
#include <shlobj.h>
#include "IGCshell.h"
#include "IGCshellDlg.h"

#define BIF_NEWDIALOGSTYLE     0x0040

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CIGCshellApp

BEGIN_MESSAGE_MAP(CIGCshellApp, CWinApp)
	//{{AFX_MSG_MAP(CIGCshellApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIGCshellApp construction

CIGCshellApp::CIGCshellApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CIGCshellApp object

CIGCshellApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CIGCshellApp initialization

BOOL CIGCshellApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	CoInitialize(NULL);

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Get application-wide registry settings

	SetRegistryKey(IDS_REGISTRYKEY);
	mDLLDirectory = GetProfileString(_T("Settings"), _T("DLLDirectory"));
	mDownloadDirectory = GetProfileString(_T("Settings"), _T("DownloadDirectory"));
	mFlightRecorder = GetProfileString(_T("Settings"), _T("FlightRecorder"));
	mCommPort = theApp.GetProfileString(_T("Settings"), _T("CommPort"));
	mDownloadValidate = GetProfileInt(_T("Settings"), _T("DownloadValidate"), 1);
	mDownloadConvert = GetProfileInt(_T("Settings"), _T("DownloadConvert"), 1);

	CIGCshellDlg dlg;
	m_pMainWnd = &dlg;
	int nResponse = dlg.DoModal();
	if (nResponse == IDOK)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with OK
	}
	else if (nResponse == IDCANCEL)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with Cancel
	}

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}

int CIGCshellApp::ExitInstance() 
{
	// Save application-wide registry settings

	WriteProfileString(_T("Settings"), _T("DLLDirectory"), mDLLDirectory);
	WriteProfileString(_T("Settings"), _T("DownloadDirectory"), mDownloadDirectory);
	WriteProfileString(_T("Settings"), _T("FlightRecorder"), mFlightRecorder);
	WriteProfileString(_T("Settings"), _T("CommPort"), mCommPort);
	WriteProfileInt(_T("Settings"), _T("DownloadValidate"), mDownloadValidate);
	WriteProfileInt(_T("Settings"), _T("DownloadConvert"), mDownloadConvert);
	
	CoUninitialize();

	return CWinApp::ExitInstance();
}

CString CIGCshellApp::BrowseForFolder(UINT titleID)
{
	CString Title;
	CString Result;

	Title.LoadString(titleID);

	BROWSEINFO BrowseInfo;
	memset(&BrowseInfo, 0, sizeof(BrowseInfo));

	char szBuffer[MAX_PATH];
	szBuffer[0] = '\0';

	BrowseInfo.hwndOwner		  = m_pMainWnd->m_hWnd;
	BrowseInfo.pszDisplayName	= szBuffer;
	BrowseInfo.lpszTitle		  = Title;
	BrowseInfo.ulFlags		    = BIF_RETURNONLYFSDIRS|BIF_NEWDIALOGSTYLE;

	// Throw display dialog
	LPITEMIDLIST pList = SHBrowseForFolder(&BrowseInfo);
	ASSERT(strlen(szBuffer) < sizeof(szBuffer));

	if (pList != NULL) {
 		// Convert from MIDLISt to real string path
 		SHGetPathFromIDList(pList, szBuffer);
 		Result = szBuffer;

	  // Global pointer to the shell's IMalloc interface.  
	  LPMALLOC pMalloc; 

	  // Get the shell's allocator and free the PIDL returned by
	  // SHBrowseForFolder.
	  if (SUCCEEDED(SHGetMalloc(&pMalloc))) {
		pMalloc->Free(pList);
		pMalloc->Release();
	  }
	}

	return Result;
}

